<?php

namespace Cms\Model\Campsite\Thematic;

use Cms\Model\AbstractModelCollection;
use POM\DomainObjectInterface;

/**
 * Class ThematicI18nCollection
 * @package Cms\Model\Campsite\Thematic
 */
class ThematicI18nCollection extends AbstractModelCollection
{

    /**
     * ThematicI18nCollection constructor.
     * @param array|null $models
     */
    public function __construct(array $models = null)
    {
        foreach ($models as $model) {
            if (\is_array($model)) {
                $this->addItem($model);
            }
        }
    }

    /**
     * @param array $modelData
     * @return \POM\DomainObjectInterface
     */
    public function handleModel(array $modelData) : DomainObjectInterface
    {
        return (new ThematicI18nModel())->populate($modelData, true);
    }
}
