<?php

namespace Cms\Model\Contract\Product;

use Cms\Model\ConfigAwareModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class ProductModel
 * @package Cms\Model\Contract\Product
 * @property int $id
 * @property int $contract_id
 * @property \Cms\Model\Contract\Product\ProductProfile $profil
 * @property string $name
 */
class ProductModel extends DomainObjectAbstract
{

    use StampAwareModelTrait;
    use ConfigAwareModelTrait;

    /** @var  int */
    protected $id;

    /** @var  int */
    protected $contract_id;

    /** @var  \Cms\Model\Contract\Product\ProductProfile */
    protected $profil;

    /** @var  string */
    protected $name;

    /**
     * @param string $offset
     * @return mixed
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \InvalidArgumentException
     */
    public function propertyGet($offset)
    {
        if ($offset === 'config') {
            return $this->getConfig();
        }
        return parent::propertyGet($offset);
    }
}
