<?php


namespace Cms\Model\Geodata;

use Cms\Model\I18nModelInterface;
use Cms\Model\I18nModelTrait;
use POM\DomainObjectAbstract;

/***
 * Class AdminI18nModel
 * @package Cms\Model\Geodata
 * @property int $id
 * @property string $name
 * @property string $name_slug
 * @property string $prefix_le
 * @property string $prefix_en
 * @property string $prefix_de
 * @property string $short_description
 * @property string $long_description
 */
class AdminI18nModel extends DomainObjectAbstract implements I18nModelInterface
{

    use I18nModelTrait;

    /**
     * @relation
     * @var int
     */
    protected $id;

    /** @var  string */
    protected $name;

    /** @var  string */
    protected $name_slug;

    /** @var  string */
    protected $prefix_le;

    /** @var  string */
    protected $prefix_en;

    /** @var  string */
    protected $prefix_de;

    /** @var  string */
    protected $short_description;

    /** @var  string */
    protected $long_description;
}
