<?php

namespace Move\Restful;

use Move\Command\CommandBusAwareTrait;
use Move\ObjectMapper\ObjectTransformer;
use POM\MapperInterface;

/**
 * Class AbstractResourceService
 * @package Move\Restful
 */
abstract class AbstractResourceService
{

    use CommandBusAwareTrait;

    /**
     * @var MapperInterface
     */
    private $mapper;

    /**
     * @var ObjectTransformer
     */
    private $transformer;

    /**
     * @return MapperInterface
     * @throws \UnexpectedValueException
     */
    public function getMapper()
    {
        if (!$this->mapper instanceof MapperInterface) {
            throw new \UnexpectedValueException('mapper is not defined properly');
        }
        return $this->mapper;
    }

    /**
     * @return ObjectTransformer
     * @throws \UnexpectedValueException
     */
    public function getTransformer()
    {
        if (!$this->transformer instanceof ObjectTransformer) {
            throw new \UnexpectedValueException('transformer is not defined properly');
        }

        return $this->transformer;
    }

    /**
     * @param MapperInterface $mapper
     * @return $this
     */
    public function setMapper(MapperInterface $mapper)
    {
        $this->mapper = $mapper;

        return $this;
    }

    /**
     * @param ObjectTransformer $transformer
     * @return $this
     */
    public function setTransformer(ObjectTransformer $transformer)
    {
        $this->transformer = $transformer;

        return $this;
    }
}
