<?php

namespace Move\Specification;

/**
 * Class LengthSpecification
 * @package Move\Specification
 */
class LengthSpecification extends Specification
{

    public const BIGGER_THAN = '>';

    public const BIGGER_EQUAL_THAN = '>=';

    public const LESS_THAN = '<';

    public const LESS_EQUAL_THAN = '<=';

    /**
     * @var int
     */
    private $length;

    /**
     * @var string
     */
    private $sign;

    /**
     * LengthSpecification constructor.
     * @param string $sign
     * @param int $length
     */
    public function __construct($sign, $length)
    {
        $this->length = $length;
        $this->sign = $sign;
    }

    /**
     * @param mixed $object
     * @return bool
     */
    public function isSatisfiedBy($object) : bool
    {
        // récuperation de la valeur a comparé
        if (\is_array($object) || $object instanceof \Countable) {
            $value = count($object);
        } elseif (is_numeric($object)) {
            $value = $object;
        } elseif (\is_string($object)) {
            $value = mb_strlen($object);
        } else {
            return false;
        }

        // execution de la comparaison
        switch ($this->sign) {
            case self::BIGGER_EQUAL_THAN:
                return $value >= $this->length;
                break;
            case self::BIGGER_THAN:
                return $value > $this->length;
                break;

            case self::LESS_EQUAL_THAN:
                return $value <= $this->length;
                break;
            case self::LESS_THAN:
                return $value < $this->length;
                break;
        }

        return false;
    }
}
