<?php

namespace Move\Template;

use League\Plates\Engine;

/**
 * Interface EngineAwareInterface
 * @package Move\Template
 */
interface EngineAwareInterface
{
    /**
     * Set Engine object.
     * @param \League\Plates\Engine $engine
     * @return $this
     */
    public function setEngine(Engine $engine);

    /**
     * Return the engine object.
     * @throws \RuntimeException if an engine object cannot be determined
     * @return \League\Plates\Engine
     */
    public function getEngine();
}
