<?php

namespace Cms\Bundle\Member;

use Psr\Http\Message\ServerRequestInterface;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;

/**
 * Class AbstractSaveMemberController
 * @package Cms\Bundle\Member
 */
abstract class AbstractSaveMemberController implements
    LoggerAwareInterface
{

    use LoggerAwareTrait;
    use MemberPasswordTrait;

    /** @var \Cms\Bundle\Member\MemberLoginService */
    private $loginService;

    /**
     * AbstractMemberController constructor.
     * @param \Cms\Bundle\Member\MemberLoginService $loginService
     */
    public function __construct(MemberLoginService $loginService)
    {
        $this->loginService = $loginService;
    }

    /**
     * @return \Cms\Bundle\Member\MemberLoginService
     */
    public function getLoginService() : MemberLoginService
    {
        return $this->loginService;
    }

    /**
     * Valide la request avant la récuperation des params, doit envoyé une
     * exception FieldMissingException en cas de soucis
     * @param \Psr\Http\Message\ServerRequestInterface $request
     * @throws \Cms\Bundle\Member\Exception\FieldMissingException
     * @return bool
     */
    abstract protected function validateRequest(ServerRequestInterface $request) : bool;

    /**
     * Renvoi un tableau clé/valeur des champs a assigné aux member
     * @param array $dataset
     * @return array
     */
    abstract protected function filterRequestForParams(array $dataset) : array;
}
