<?php

namespace Cms\Client\Article\Model;

use Cms\Client\BackdateModelTrait;
use Cms\LinkResource\FlattenResourcesAwareInterface;
use Cms\LinkResource\FlattenResourcesTrait;
use Cms\Model\Article\ArticleModel;
use Cms\Model\Article\LinkResource\LinkResourceModel;
use Cms\Model\Article\Plugin\PluginModel;

/**
 * Class ArticleRestfulModel
 * @package Cms\Client\Article\Model
 *
 * @property \Cms\Model\Article\ArticleI18nModel[] $i18n
 * @property AssetRestfulModel[] $assets
 * @property array $plugins
 * @property array $tasks
 * @property array $tags
 * @property array $categories
 * @property array $articles
 * @property bool $hasGallery
 * @property bool $hasVideoEmbed
 * @property int $closeEmbargoTask
 */
class ArticleRestfulModel extends ArticleModel implements
    FlattenResourcesAwareInterface
{

    use FlattenResourcesTrait;
    use BackdateModelTrait;

    /** @var  AssetRestfulModel[] */
    protected $assets;

    /** @var  \Cms\Model\Article\ArticleI18nModel[] */
    protected $i18n;

    /** @var  array */
    protected $articles;

    /** @var  array */
    protected $plugins;

    /** @var  array */
    protected $tasks;

    /** @var  array */
    protected $tags;

    /** @var  array */
    protected $categories;

    /** @var  bool */
    protected $hasGallery;

    /** @var  bool */
    protected $hasVideoEmbed;

    /** @var  int */
    protected $closeEmbargoTask;

    /**
     * @return array|PluginModel[]
     */
    public function getFlattenPlugins()
    {
        $value = !empty($this->plugins) ? \call_user_func_array('array_merge', $this->plugins) : [];
        foreach ($value as &$plugin) {
            if (!$plugin instanceof PluginModel) {
                $plugin = (new PluginModel())->populate($plugin, true);
            }
        }
        return $value;
    }

    /**
     * @param LinkResourceModel|array $resourceData
     * @return LinkResourceModel
     */
    public function handleResource($resourceData)
    {
        if (!$resourceData instanceof LinkResourceModel) {
            $resourceData = (new LinkResourceModel())->populate($resourceData, true);
        }
        return $resourceData;
    }

    /**
     * @param string $name
     * @param mixed $value
     */
    public function propertySet($name, $value)
    {
        if ($name === 'articles' && \is_array($value)) {
            $value = array_map(function ($item) {
                return is_numeric($item) ? ['link_article_id' => $item] : $item;
            }, $value);
        }
        parent::propertySet($name, $value);
    }
}
