<?php

namespace Cms\Client\Contract\Model;

use Cms\LinkResource\AbstractLinkResourceModel;
use Cms\LinkResource\FlattenResourcesAwareInterface;
use Cms\LinkResource\FlattenResourcesTrait;
use Cms\Model\Contract\Product\ProductConfigModel;
use Cms\Model\Contract\Product\ProductConfigResourceModel;

/**
 * Class ProductConfigRestfulModel
 * @package Cms\Client\Contract\Model
 *
 * @property \Cms\Client\Contract\Model\ProductConfigAssetRestfulModel[] $assets
 * @property \Cms\Model\Contract\Product\ProductConfigI18nModel[] $i18n
 */
class ProductConfigRestfulModel extends ProductConfigModel implements
    FlattenResourcesAwareInterface
{

    use FlattenResourcesTrait;

    /** @var  \Cms\Client\Contract\Model\ProductConfigAssetRestfulModel[] */
    protected $assets;

    /** @var  \Cms\Model\Contract\Product\ProductConfigI18nModel[] */
    protected $i18n;

    /**
     * @param AbstractLinkResourceModel|array $resourceData
     * @return AbstractLinkResourceModel
     */
    public function handleResource($resourceData)
    {
        if (!$resourceData instanceof ProductConfigResourceModel) {
            $resourceData = (new ProductConfigResourceModel())->populate($resourceData, true);
        }
        return $resourceData;
    }
}
