<?php

namespace Cms\Client\Scheduler\Model;

use Cms\LinkResource\FlattenResourcesAwareInterface;
use Cms\LinkResource\FlattenResourcesTrait;
use Cms\Model\Scheduler\LinkResource\LinkResourceModel;
use Cms\Model\Scheduler\Task\TaskModel;

/**
 * Class TaskRestfulModel
 * @package Cms\Client\Scheduler\Model
 * @property \Cms\Model\Scheduler\Log\LogModel $last_log
 */
class TaskRestfulModel extends TaskModel implements
    FlattenResourcesAwareInterface
{

    use FlattenResourcesTrait;

    /** @var  \Cms\Model\Scheduler\Log\LogModel */
    protected $last_log;

    /**
     * @param LinkResourceModel|array $resourceData
     * @return LinkResourceModel
     */
    public function handleResource($resourceData)
    {
        if (!$resourceData instanceof LinkResourceModel) {
            $resourceData = (new LinkResourceModel())->populate($resourceData, true);
        }
        return $resourceData;
    }
}
