<?php


namespace Cms\Client;

use Cms\Model\ScopeModel;
use POM\DomainObjectInterface;

/**
 * Class ScopeClient
 * @package Cms\Client
 */
class ScopeClient extends AbstractClient
{

    protected $basePath = 'scope';

    /**
     * @param array $dataset
     * @return DomainObjectInterface
     */
    public function handleData($dataset = [])
    {
        return (new ScopeModel())->populate($dataset ?: [], true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|ScopeModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }
}
