<?php


namespace Cms\Client\Service;

use Cms\Client\Article\ArticleClient;
use Cms\Client\Article\CategoryClient;
use Cms\Client\Article\ContainerClient;
use Cms\Client\Article\LinkResourceClient;
use Cms\Client\Article\Transformer\ArticleTransformer;
use Move\Command\Command\FetchBulkCommand;
use Move\Command\CommandBusInterface;

/**
 * Class ArticleService
 * @package Cms\Client\Service
 */
class ArticleService
{

    /** @var \Cms\Client\Article\ArticleClient */
    private $articleClient;

    /** @var \Cms\Client\Article\CategoryClient */
    private $categoryClient;

    /** @var \Cms\Client\Article\Transformer\ArticleTransformer */
    private $articleTransformer;

    /** @var \Cms\Client\Article\LinkResourceClient */
    private $linkResourceClient;

    /** @var \Move\Command\CommandBusInterface */
    private $articleCmdBus;

    /** @var \Move\Command\CommandBusInterface */
    private $categoryCmdBus;

    /** @var \Cms\Client\Article\ContainerClient */
    private $containerClient;

    /**
     * ArticleService constructor.
     * @param \Cms\Client\Article\ArticleClient $articleClient
     * @param \Cms\Client\Article\CategoryClient $categoryClient
     * @param \Cms\Client\Article\ContainerClient $containerClient
     * @param \Cms\Client\Article\LinkResourceClient $linkResourceClient
     * @param \Cms\Client\Article\Transformer\ArticleTransformer $articleTransformer
     * @param \Move\Command\CommandBusInterface $articleCmdBus
     * @param \Move\Command\CommandBusInterface $categoryCmdBus
     */
    public function __construct(
        ArticleClient $articleClient,
        CategoryClient $categoryClient,
        ContainerClient $containerClient,
        LinkResourceClient $linkResourceClient,
        ArticleTransformer $articleTransformer,
        CommandBusInterface $articleCmdBus,
        CommandBusInterface $categoryCmdBus
    ) {

        $this->articleClient = $articleClient;
        $this->categoryClient = $categoryClient;
        $this->articleTransformer = $articleTransformer;
        $this->linkResourceClient = $linkResourceClient;
        $this->articleCmdBus = $articleCmdBus;
        $this->categoryCmdBus = $categoryCmdBus;
        $this->containerClient = $containerClient;
    }

    /**
     * @return ArticleClient
     */
    public function getArticleClient() : ArticleClient
    {
        return $this->articleClient;
    }

    /**
     * @return CategoryClient
     */
    public function getCategoryClient() : CategoryClient
    {
        return $this->categoryClient;
    }

    /**
     * @return ArticleTransformer
     */
    public function getArticleTransformer() : ArticleTransformer
    {
        return $this->articleTransformer;
    }

    /**
     * @return LinkResourceClient
     */
    public function getLinkResourceClient() : LinkResourceClient
    {
        return $this->linkResourceClient;
    }

    /**
     * @return CommandBusInterface
     */
    public function getArticleCommandBus() : CommandBusInterface
    {
        return $this->articleCmdBus;
    }

    /**
     * @return CommandBusInterface
     */
    public function getCategoryCommandBus() : CommandBusInterface
    {
        return $this->categoryCmdBus;
    }

    /**
     * @return \Cms\Client\Article\ContainerClient
     */
    public function getContainerClient() : ContainerClient
    {
        return $this->containerClient;
    }

    /**
     * @param array $articleIds
     * @return \Cms\Client\Article\Model\ArticleRestfulModel[]
     */
    public function getArticles(array $articleIds) : array
    {
        $command = new FetchBulkCommand($articleIds);
        return $this->articleCmdBus->handle($command);
    }
}
