<?php

namespace Cms\Client\Service;

use Cms\Client\CmsHttpClientInterface;
use Cms\Client\CmsUser\CmsUserClient;
use Cms\Client\CmsUser\CmsUserSessionClient;
use League\Container\ServiceProvider\AbstractServiceProvider;

/**
 * Class CmsUserProvider
 * @package Cms\Client\Service
 */
class CmsUserProvider extends AbstractServiceProvider
{

    /** @var array */
    protected $provides = [
        CmsUserClient::class,
        CmsUserSessionClient::class,
        CmsUserService::class,
    ];

    /**
     * @inheritdoc
     */
    public function register()
    {
        // add user client
        $this->container->add(CmsUserClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // add session client
        $this->container->add(CmsUserSessionClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // add service
        $this->container->add(CmsUserService::class)
            ->withArgument(CmsUserClient::class)
            ->withArgument(CmsUserSessionClient::class);
    }
}
