<?php


namespace Cms\Client\Service;

/**
 * Trait CmsUserServiceAwareTrait
 * @package Cms\Client\Service
 */
trait CmsUserServiceAwareTrait
{

    /** @var  \Cms\Client\Service\CmsUserService */
    protected $cmsUserService;

    /**
     * @deprecated
     * @var  \Cms\Client\Service\CmsUserService
     */
    protected $userService;

    /**
     * @param \Cms\Client\Service\CmsUserService $cmsUserService
     * @return $this
     */
    public function setCmsUserService(CmsUserService $cmsUserService)
    {
        $this->cmsUserService = $cmsUserService;
        return $this;
    }

    /**
     * @return \Cms\Client\Service\CmsUserService
     * @throws \DomainException
     */
    public function getCmsUserService() : CmsUserService
    {
        // concerve la compatibilité
        if ($this->userService instanceof CmsUserService) {
            $this->cmsUserService = $this->userService;
        }

        if (!$this->cmsUserService instanceof CmsUserService) {
            throw new \DomainException('cmsUserService is not a CmsUserService instance');
        }
        return $this->cmsUserService;
    }
}
