<?php

namespace Cms\Extension\Component;

use Cms\Extension\MediaHandler\MediaHandlerSizeTrait;
use League\Plates\Template\Template;
use Move\Template\Component\AbstractComponent;
use Move\Utils\ClassDetectorTrait;

/**
 * Class FigureComponent
 * @package Cms\Extension\Component
 */
class FigureComponent extends AbstractComponent
{

    use ClassDetectorTrait;
    use MediaHandlerSizeTrait;

    /**
     * FigureComponent constructor.
     * @param string|null $defaultFormatName
     */
    public function __construct(string $defaultFormatName = null)
    {
        $this->functionName = 'figure';
        $this->formatName = $defaultFormatName ?: 'default';
    }

    /**
     * @param Template $template
     * @param array $data
     */
    protected function assignData(Template $template, $data = [])
    {
        $format = !empty($data['format']) ? $data['format'] : $this->formatName;
        if (!empty($this->formatSize[$format])) {
            $data = array_merge($data, $this->formatSize[$format]);
        } else {
            $message = 'asset format ' . $format . ' is unknown in ' . $this->getClassShortName();
            trigger_error($message, E_USER_WARNING);
        }
        $template->data($data);
    }
}
