<?php


namespace Cms\Mail;

/**
 * Interface SenderAdapterInterface
 * @package Cms\Mail
 */
interface SenderAdapterInterface
{

    /**
     * @param array $to
     * @param string $subject
     * @param string $htmlBody
     * @param string|null $textBody
     * @param array $attachs
     * @return bool
     */
    public function sendHtmlMail(
        array $to,
        $subject,
        $htmlBody,
        $textBody = null,
        array $attachs = []
    );
}
