<?php


namespace Cms\Model\Article;

use NewcomDigital\Enum\Enum;

/**
 * Class ArticleState
 * @package Cms\Model\Article
 */
class ArticleState extends Enum
{

    /** Article publié */
    const PUBLISH = 'publish';

    /** Article corrigé (state temporaire en cas de mise a jour du status) */
    const CORRECT = 'correct';

    /** Article supprimé */
    const DELETE = 'delete';

    /** Article en brouillon */
    const DRAFT = 'draft';

    /** Article en embargo */
    const EMBARGO = 'embargo';

    /** Le SR doit passer sur le papier */
    const ATTENTE_SR = 'waitsr';

    /** Le SR a valider le papier */
    const VALIDE_SR = 'validsr';
}
