<?php


namespace Cms\Model\Article\Category;

use Cms\Model\ConfigAwareModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class CategoryPluginModel
 * @package Cms\Model\Article\Category
 * @property int $id
 * @property int $category_id
 * @property CategoryPluginType $type
 */
class CategoryPluginModel extends DomainObjectAbstract
{

    use StampAwareModelTrait;
    use ConfigAwareModelTrait;

    /** @var  int */
    protected $id;

    /** @var  int */
    protected $category_id;

    /** @var  CategoryPluginType */
    protected $type;

    /**
     * @param string $offset
     * @param mixed $value
     */
    public function propertySet($offset, $value)
    {
        if ($offset === 'config') {
            $this->setConfig($value);
        } else {
            parent::propertySet($offset, $value);
        }
    }
}
