<?php

namespace Cms\Model\Article\Category;

use Cms\Specification\SlugSpecification;
use Move\Filter\Filter;
use Move\Filter\Validator\AbstractDomainObjectStateValidator;
use Move\Specification\EnumSpecification;
use Move\Specification\LengthSpecification;
use Move\Specification\PhpFilterVarSpecification;

/**
 * Class CategoryValidator
 * @package Cms\Model\Article\Category
 */
class CategoryValidator extends AbstractDomainObjectStateValidator
{

    /**
     * @return Filter
     * @throws \InvalidArgumentException
     */
    protected function createFilter()
    {
        // filtre du model
        $myFilter = new Filter([
            'scope_id' => true,
            'name' => true,
            'slug' => new SlugSpecification(),
            'rank' => (new PhpFilterVarSpecification(FILTER_VALIDATE_INT))->andSpec(
                new LengthSpecification(LengthSpecification::BIGGER_EQUAL_THAN, 1)
            ),
            'state' => new EnumSpecification(CategoryState::class),
            'profil' => new EnumSpecification(CategoryProfil::class),
        ]);
        $myFilter->modify('state', function ($state) {
            return (string)$state;
        });

        return $myFilter;
    }
}
