<?php


namespace Cms\Model\Campsite\Group;

use Cms\Model\I18nModelInterface;
use Cms\Model\I18nModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class GroupLogoModel
 * @package Cms\Model\Campsite\Group
 * @property int $group_id
 * @property string $logo_path
 * @property string $short_teaser
 * @property string $teaser
 */
class GroupLogoModel extends DomainObjectAbstract implements I18nModelInterface
{

    use StampAwareModelTrait;
    use I18nModelTrait;

    /**
     * @relation
     * @var int
     */
    protected $group_id;

    /** @var  string */
    protected $logo_path;

    /** @var  string */
    protected $short_teaser;

    /** @var  string */
    protected $teaser;
}
