<?php

namespace Cms\Model\Campsite\Thematic;

use Cms\Model\CmsUserIdAwareTrait;
use Cms\Model\ScopeAwareModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class ThematicModel
 * @package Cms\Model\Campsite\Thematic
 * @property int $id
 * @property int $rank
 * @property string $slug
 * @property string $name
 * @property string $name_dyn
 * @property string $short_description
 * @property string $description
 * @property ThematicType $type
 * @property bool $sellable
 */
class ThematicModel extends DomainObjectAbstract
{

    use StampAwareModelTrait;
    use ScopeAwareModelTrait;
    use CmsUserIdAwareTrait;

    /** @var  int */
    protected $id;

    /** @var  int */
    protected $rank;

    /** @var  string */
    protected $slug;

    /** @var  string */
    protected $name;

    /** @var  string */
    protected $name_dyn;

    /** @var  string */
    protected $short_description;

    /** @var  string */
    protected $description;

    /** @var  ThematicType */
    protected $type;

    /** @var  bool */
    protected $sellable;
}
