<?php

namespace Cms\Model\Contract\Product;

use Cms\LinkResource\LinkResourceModel;
use Cms\Model\CmsUserIdAwareTrait;
use Cms\Model\ConfigAwareModelTrait;
use Cms\Model\StampAwareModelTrait;

/**
 * Class ProductConfigModel
 * @package Cms\Model\Contract\Product
 * @property int $product_id
 * @property \Cms\Model\Contract\Product\ProductConfigState $state
 * @property \DateTime $begin_at
 * @property \DateTime $end_at
 */
class ProductConfigModel extends LinkResourceModel
{

    use StampAwareModelTrait;
    use CmsUserIdAwareTrait;
    use ConfigAwareModelTrait;

    /** @var  int */
    protected $product_id;

    /** @var  \Cms\Model\Contract\Product\ProductConfigState */
    protected $state;

    /** @var  \DateTime */
    protected $begin_at;

    /** @var  \DateTime */
    protected $end_at;

    /**
     * @param string $offset
     * @return mixed
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \InvalidArgumentException
     */
    public function propertyGet($offset)
    {
        if ($offset === 'config') {
            return $this->getConfig();
        }
        return parent::propertyGet($offset);
    }
}
