<?php


namespace Cms\Model;

use Move\Utils\ClassDetectorTrait;

/**
 * Class RelationAwareModelTrait
 * @package Cms\Model
 */
trait RelationAwareModelTrait
{

    use ClassDetectorTrait;

    /**
     * @return array
     */
    public function getRelationProperties() : array
    {
        $reflectClass = $this->getReflectorClass();
        $props = array_map(
            function (\ReflectionProperty $reflectProp) {
                // parse le comment pou trouver le @relation
                if ($this->isRelationProperty($reflectProp)) {
                    return $reflectProp->getName();
                }
                return null;
            },
            $reflectClass->getProperties(\ReflectionProperty::IS_PROTECTED)
        );
        return array_values(array_filter($props));
    }

    /**
     * @return array
     */
    public function getRelationValues() : array
    {
        $props = $this->getRelationProperties();
        $values = array_map(function ($propName) {
            return $this[$propName];
        }, $props);
        return array_combine($props, $values);
    }

    /**
     * @param string|\ReflectionProperty $property
     * @return bool
     */
    protected function isRelationProperty($property) : bool
    {
        // check type
        if (!$property instanceof \ReflectionProperty) {
            $property = $this->getReflectorClass()->getProperty($property);
        }
        // parse le comment pou trouver le @relation
        if (preg_match('/@relation/', $property->getDocComment())) {
            return true;
        }
        return false;
    }
}
