<?php

namespace Cms;

/**
 * Class PathFactory
 * @package Cms
 */
class PathFactory
{

    /**
     * @param string $appName
     * @return string
     */
    public static function getAppBasePath($appName) : string
    {
        return 'apps/' . ucfirst($appName) . '/';
    }

    /**
     * Renvoi le chemin des sources de l'appli
     * @param string $appName
     * @return string
     */
    public static function getAppSrcPath($appName) : string
    {
        return self::getAppBasePath($appName) . 'src/';
    }

    /**
     * Renvoi le chemin de config d'une appli ou de base
     * @param null|string $appName
     * @return string
     */
    public static function getConfigPath(string $appName = null) : string
    {
        $appBasePath = '';
        if ($appName) {
            $appBasePath = self::getAppBasePath($appName);
        }
        return $appBasePath . 'config/';
    }
}
