<?php

namespace Move\Command\Command;

/**
 * Class DeleteCommand
 * @package Move\Command\Command
 */
class DeleteCommand implements DryRunCommandInterface
{

    use DryRunCommandTrait;

    /** @var  int */
    protected $id;

    /**
     * DeleteCommand constructor.
     * @param int $id
     */
    public function __construct($id)
    {
        $this->id = $id;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     * @return DeleteCommand
     */
    public function withId($id) : DeleteCommand
    {
        $clone = clone $this;
        $clone->id = $id;
        return $clone;
    }
}
