<?php


namespace Move\Embed;

use GuzzleHttp\Client;
use Move\Http\Client\GuzzleClientAdapter;
use Move\Http\Client\HttpClientInterface;
use Psr\Cache\CacheItemPoolInterface;

/**
 * Class EmbedFactory
 * @package Move\Embed
 */
class EmbedFactory
{
    /**
     * @param string $host
     * @return HttpClientInterface
     * @throws \InvalidArgumentException
     */
    public static function createClient($host) : HttpClientInterface
    {
        $client = new GuzzleClientAdapter(new Client(), $host);
        return $client;
    }

    /**
     * @param string|null $digitekaMdtk
     * @param string|null $gmapsApiKey
     * @return \Move\Embed\EmbedMapper
     */
    public static function createMapper(
        string $digitekaMdtk = null,
        string $gmapsApiKey = null
    ) : EmbedMapper {
        $youtube = new AdapterProvider\Youtube();

        // ajoute le default mdtk
        if ($digitekaMdtk && !AdapterProvider\Digiteka::$DEFAULT_MDTK) {
            AdapterProvider\Digiteka::$DEFAULT_MDTK = $digitekaMdtk;
        }
        $digiteka = new AdapterProvider\Digiteka($digitekaMdtk);
        $youtube->setSuccessor($digiteka);

        // ajoute l'api key de gmaps
        $gmaps = new AdapterProvider\GoogleMaps($gmapsApiKey);
        $youtube->setSuccessor($gmaps);

        // appel generique simple
        $twitter = new AdapterProvider\Twitter();
        $youtube->setSuccessor($twitter);

        $fbvideo = new AdapterProvider\FacebookVideo();
        $youtube->setSuccessor($fbvideo);

        $dailymotion = new AdapterProvider\Dailymotion();
        $youtube->setSuccessor($dailymotion);

        $twitter = new AdapterProvider\Instagram();
        $youtube->setSuccessor($twitter);

        $vimeo = new AdapterProvider\Vimeo();
        $youtube->setSuccessor($vimeo);

        $fallback = new AdapterProvider\FallbackAdapter();
        $youtube->setSuccessor($fallback);

        $mapper = new EmbedMapper($youtube);
        return $mapper;
    }

    /**
     * @param \Psr\Cache\CacheItemPoolInterface $cachePool
     * @param string|null $digitekaMdtk
     * @param string|null $gmapsApiKey
     * @return \Move\Embed\EmbedMapper
     */
    public static function createMapperWithCache(
        CacheItemPoolInterface $cachePool,
        string $digitekaMdtk = null,
        string $gmapsApiKey = null
    ) : EmbedMapper {
        $mapper = self::createMapper($digitekaMdtk, $gmapsApiKey);
        $mapper->setItemCachePool($cachePool);
        return $mapper;
    }
}
