<?php


namespace Move\Embed\Parser;

/**
 * Class RegexParser
 * @package Move\Embed\Parser
 */
class RegexParser implements ParserInterface
{

    /** @var string */
    private $regex;

    /**
     * RegexParser constructor.
     * @param string $regex
     */
    public function __construct($regex)
    {
        $this->regex = $regex;
    }

    /**
     * @param string $sourceUri
     * @param array $extractedParams
     * @return bool
     */
    public function __invoke($sourceUri, &$extractedParams = [])
    {
        return $this->matchString($sourceUri, $extractedParams) === 1;
    }

    /**
     * @param string $str
     * @param array $extractedParams
     * @return bool
     */
    public function matchString($str, &$extractedParams = [])
    {
        return preg_match($this->regex, $str, $extractedParams) === 1;
    }
}
