<?php

namespace Move\Http\Controller;

use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

/**
 * Interface ResourceControllerInterface
 * @package Move\Http\Controller
 */
interface ResourceControllerInterface
{

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param array $vars
     * @return mixed
     */
    public function options(ServerRequestInterface $request, ResponseInterface $response, $vars = []);

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param array $vars
     * @return mixed
     */
    public function index(ServerRequestInterface $request, ResponseInterface $response, $vars = []);

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param array $vars
     * @return mixed
     */
    public function show(ServerRequestInterface $request, ResponseInterface $response, $vars = []);

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param array $vars
     * @return mixed
     */
    public function create(ServerRequestInterface $request, ResponseInterface $response, $vars = []);

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param array $vars
     * @return mixed
     */
    public function update(ServerRequestInterface $request, ResponseInterface $response, $vars = []);

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param array $vars
     * @return mixed
     */
    public function delete(ServerRequestInterface $request, ResponseInterface $response, $vars = []);
}
