<?php


namespace Move\Restful;

use Move\Command\CommandBusInterface;
use Move\ObjectMapper\ObjectTransformer;
use POM\MapperInterface;

/**
 * Class ResourceServiceAwareTrait
 * @package Move\Restful
 */
trait ResourceServiceAwareTrait
{

    /** @var  ResourceServiceInterface */
    protected $service;

    /**
     * @return ResourceServiceInterface
     */
    protected function getResourceService()
    {
        if (!$this->service instanceof ResourceServiceInterface) {
            throw new \UnexpectedValueException('resource service is not set');
        }
        return $this->service;
    }

    /**
     * @param ResourceServiceInterface $service
     * @return $this
     */
    protected function setResourceService(ResourceServiceInterface $service)
    {
        $this->service = $service;
        return $this;
    }


    /**
     * @return CommandBusInterface
     */
    protected function getCommandBus()
    {
        return $this->getResourceService()->getCommandBus();
    }

    /**
     * @return ObjectTransformer
     */
    protected function getTransformer()
    {
        return $this->getResourceService()->getTransformer();
    }

    /**
     * @return MapperInterface
     */
    protected function getMapper()
    {
        return $this->getResourceService()->getMapper();
    }
}
