<?php

namespace Move\Specification;

/**
 * Interface SpecificationInterface
 * @package Move\Specification
 */
interface SpecificationInterface
{

    /**
     * @param mixed $object
     * @return bool
     */
    public function isSatisfiedBy($object);

    /**
     * @param SpecificationInterface $specification
     * @return $this
     */
    public function andSpec(SpecificationInterface $specification);

    /**
     * @param SpecificationInterface $specification
     * @return $this
     */
    public function orSpec(SpecificationInterface $specification);

    /**
     * @return $this
     */
    public function notSpec();
}
