<?php


namespace Move\Template\Component;

use League\Plates\Template\Template;

/**
 * Class BreadcrumpComponent
 * @package Move\Template\Component
 */
class BreadcrumpComponent extends AbstractComponent
{

    /** @var  BreadcrumpComponent */
    private static $instance;

    /** @var string  */
    protected $functionName = 'breadcrump';

    /** @var  array */
    private $items;


    /**
     * @return BreadcrumpComponent
     */
    public static function GetInstance()
    {
        return self::$instance ?: self::$instance = new self();
    }

    /**
     * BreadcrumpComponent constructor.
     */
    private function __construct()
    {
        $this->setRootElement();
    }

    /**
     *
     */
    public function __clone()
    {
        throw new \RuntimeException('cannot clone this instance');
    }


    /**
     * @param string $rootTitle
     * @param string $rootLink
     */
    public function setRootElement($rootTitle = 'Home', $rootLink = '/')
    {
        $this->items[0] = [
            'title' => $rootTitle,
            'link' => $rootLink
        ];
    }

    /**
     * @param string $title
     * @param null|string $link
     * @return $this
     */
    public function addElement($title, $link = null)
    {
        $this->items[] = [
            'title' => $title,
            'link' => $link
        ];
        return $this;
    }

    /**
     * @param Template $template
     * @param array $data
     */
    protected function assignData(Template $template, $data = [])
    {
        foreach ($data as $title) {
            $this->addElement($title);
        }
        $template->data([
            'items' => $this->items,
        ]);
    }
}
