<?php

namespace Move\Template\Html\Meta;

/**
 * Class Title
 * @package Html\Metadata
 */
class Title implements MetaInterface
{

    /** @var string */
    protected $value;

    /**
     * Meta Title
     * @param string $value
     */
    public function __construct($value)
    {
        $this->value = $value;
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return $this->render();
    }

    /**
     * Retourne un identifiant
     */
    public function ident() : string
    {
        return 'title';
    }

    /**
     * @{@inheritdoc}
     */
    public function render() : string
    {
        $source = '<title>' . $this->value . '</title>';
        return $source;
    }

    /**
     * Renvoi la copie sous forme de tableau de la metadata
     * @return array
     */
    public function getArrayCopy() : array
    {
        return [
            'title' => $this->value,
        ];
    }
}
