<?php

namespace Move\Jato\Mapper;

use GuzzleHttp\Client;
use Move\Command\Exception\BadParameterException;
use Move\Http\Client\GuzzleClientAdapter;
use Move\Jato\JatoClient;
use PHPUnit\Framework\TestCase;

/**
 * Class VehicleBuilderMapperTest
 * @package Move\Jato\Mapper
 */
class VehicleBuilderMapperTest extends TestCase
{
    /**
     * @return VehicleBuilderMapper
     */
    public function testConstruct() : VehicleBuilderMapper
    {
        $email = 'nlegall@movepublishing.com';
        $password = 'king7queen';

        $client = new JatoClient(
            new GuzzleClientAdapter(new Client(), 'webapi-live.jato.com/jato.carspecs.api'), $email,
            $password
        );

        $mapper = new VehicleBuilderMapper($client);
        $clientTest = $mapper->getClient();

        $this->assertInstanceOf(JatoClient::class, $clientTest, 'Not a JatoClient');
        $this->assertEquals($client, $clientTest, 'Client error');

        return $mapper;
    }

    /**
     * @depends testConstruct
     * @param VehicleBuilderMapper $mapper
     */
    public function testGetClient(VehicleBuilderMapper $mapper)
    {
        $client = $mapper->getClient();
        $this->assertInstanceOf(JatoClient::class, $client, 'Error getClient');
    }

    /**
     * @depends testConstruct
     * @param VehicleBuilderMapper $mapper
     */
    public function testGetVehicleBuilder(VehicleBuilderMapper $mapper)
    {
        $dataBase = 'SSCF_CS2002';
        $benchMarkVehicleId = '1';
        $vehicleId = '777513320170101';
        $result = $mapper->getVehicleBuilder($benchMarkVehicleId, $dataBase, $vehicleId);

        $this->assertInternalType('array', $result, 'Not an array');
        $this->assertNotNull($result['vehicleHeaderInfo']);
    }

    /**
     * @depends testConstruct
     * @param VehicleBuilderMapper $mapper
     */
    public function testGetVehicleBuilderOneVehicle(VehicleBuilderMapper $mapper)
    {
        $dataBase = 'SSCF_CS2002';
        $benchMarkVehicleId = '777513320170101';
        $result = $mapper->getVehicleBuilder($benchMarkVehicleId, $dataBase);

        $this->assertInternalType('array', $result, 'Not an array');
        $this->assertNotNull($result['vehicleHeaderInfo']);
    }

    /**
     * @depends testConstruct
     * @param VehicleBuilderMapper $mapper
     */
    public function testGetVehicleBuilderInvalid(VehicleBuilderMapper $mapper)
    {
        $this->expectException(BadParameterException::class);
        $dataBase = null;
        $benchMarkVehicleId = null;
        $mapper->getVehicleBuilder($benchMarkVehicleId, $dataBase);
    }

    /**
     * @depends testConstruct
     * @param VehicleBuilderMapper $mapper
     */
    public function testGetVehicleBuilderNull(VehicleBuilderMapper $mapper)
    {
        $dataBase = 'SSCF_CS2002';
        $benchMarkVehicleId = '777513320170111';
        $result = $mapper->getVehicleBuilder($benchMarkVehicleId, $dataBase);

        $this->assertNull($result['vehicleHeaderInfo']);
    }

}