<?php


namespace Cms;

use League\Container\Container;
use League\Container\ContainerAwareTrait;
use Move\Bootstrap\EngineBootstrap;
use Move\Http\BootstrapServerInterface;

/**
 * Class AbstractBootstrap
 * @package Cms
 */
abstract class AbstractBootstrap implements BootstrapServerInterface
{

    use ContainerAwareTrait;

    /**
     * AbstractBootstrap constructor.
     * @param Container $container
     * @throws \LogicException
     * @throws \Psr\Cache\InvalidArgumentException
     */
    public function __construct(Container $container)
    {
        $this->setContainer($container);

        // ajout du gestionnaire de template
        (new EngineBootstrap())->bootstrap($container);
    }
}
