<?php

namespace Cms\Client\AddressBook\Model;

use Cms\Client\AddressBook\ContactAwareModelTrait;
use Cms\Client\AttributeAwareModelTrait;
use Cms\Model\AddressBook\Address\AddressAttributeModel;
use Cms\Model\AddressBook\Address\AddressModel;

/**
 * Class AddressRestfulModel
 * @package Cms\Client\AddressBook\Model
 * @property array $addressbooks
 * @property array $categories
 */
class AddressRestfulModel extends AddressModel
{

    use AttributeAwareModelTrait;
    use ContactAwareModelTrait;

    /** @var  array */
    protected $addressbooks;

    /** @var  array */
    protected $categories;

    /**
     * @param AddressAttributeModel|array $attributeData
     * @return AddressAttributeModel
     */
    public function handleAttribute($attributeData)
    {
        if (!$attributeData instanceof AddressAttributeModel) {
            $attributeData = (new AddressAttributeModel())->populate($attributeData, true);
        }
        return $attributeData;
    }
}
