<?php

namespace Cms\Client\Article\Model;

use Cms\Client\AssetConfigAwareModelTrait;
use Cms\Client\BackdateModelTrait;
use Cms\Model\Article\Category\CategoryModel;

/**
 * Class CategoryRestfulModel
 * @package Cms\Client\Article\Model
 * @property int $parent_id
 * @property \Cms\Model\Article\Category\CategoryI18nModel[] $i18n
 * @property \Cms\Model\Article\Category\CategoryPluginModel[] $plugins
 */
class CategoryRestfulModel extends CategoryModel
{

    use BackdateModelTrait;
    use AssetConfigAwareModelTrait;

    /** @var  int */
    protected $parent_id;

    /** @var  \Cms\Model\Article\Category\CategoryPluginModel[] */
    protected $plugins;

    /** @var  \Cms\Model\Article\Category\CategoryI18nModel[] */
    protected $i18n;
}
