<?php

namespace Cms\Client\Campsite;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Model\Campsite\CampsiteLogModel;

/**
 * Class CampsiteLogClient
 * @package Cms\Client\Campsite
 */
class CampsiteLogClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'campsite';

    /**
     * @param array $dataset
     * @return CampsiteLogModel
     */
    public function handleData($dataset = []) : CampsiteLogModel
    {
        return (new CampsiteLogModel())->populate($dataset, true);
    }

    /**
     * @param array $types
     * @return \Cms\Client\CmsApiIndexIterator|CampsiteLogModel[]
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpServerException
     */
    public function fetchAllByType(array $types) : CmsApiIndexIterator
    {
        $result = $this->loadIndexFromClient([$this->basePath, 'campsite-log'], [
            'filter' => [
                'type' => $types,
            ],
            'page' => -1,
        ]);
        return $result;
    }

    /**
     * @param int $campsiteId
     * @return \Cms\Client\CmsApiIndexIterator|CampsiteLogModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpServerException
     */
    public function fetchAllByCampsite(int $campsiteId) : CmsApiIndexIterator
    {
        $result = $this->loadIndexFromClient([$this->basePath, $campsiteId, 'log'], [
            'page' => -1,
        ]);
        return $result;
    }

    /**
     * @param array $queryParams
     * @return array
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        return [];
    }
}
