<?php

namespace Cms\Client\Contract\Model;

use Cms\LinkResource\FlattenResourcesTrait;
use Cms\LinkResource\LinkResourceModel;
use Cms\Model\Contract\ContractModel;
use Cms\Model\Contract\Product\ProductResourceModel;

/**
 * Class ContractRestfulModel
 * @package Cms\Client\Contract\Model
 * @property \Cms\Client\Contract\Model\ProductRestfulModel[] $products
 */
class ContractRestfulModel extends ContractModel
{

    use FlattenResourcesTrait;

    /** @var  \Cms\Client\Contract\Model\ProductRestfulModel[] */
    protected $products;

    /**
     * @param $resourceData
     * @return LinkResourceModel
     */
    public function handleResource($resourceData)
    {
        if (!$resourceData instanceof ProductResourceModel) {
            $resourceData = (new ProductResourceModel())->populate($resourceData, true);
        }
        return $resourceData;
    }
}
