<?php


namespace Cms\Client\Geodata;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Model\Geodata\CountryModel;

/**
 * Class CountryClient
 * @package Cms\Client\Geodata
 */
class CountryClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'geodata/country';

    /**
     * @param array $dataset
     * @return CountryModel
     */
    public function handleData($dataset = []) : CountryModel
    {
        return (new CountryModel())->populate($dataset, true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|CountryModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param string $search
     * @param int $pageNum
     * @return \Cms\Client\CmsApiIndexIterator|CountryModel[]
     */
    public function getIndexBySearch(string $search, int $pageNum = 0)
    {
        return $this->getBuilder()
            ->setFilter('search', $search)
            ->getIndex($pageNum);
    }
}
