<?php

namespace Cms\Controller;

use Cms\Client\Article\Model\CategoryRestfulModel;
use Cms\Engine\EngineDecoratorAwareInterface;
use Cms\Engine\EngineDecoratorAwareTrait;
use Move\Template\AssetEngineTrait;
use Move\Template\EngineAwareInterface;
use Move\Template\EngineAwareTrait;
use Move\Template\MetaEngineTrait;

/**
 * Class AbstractEngineController
 * @package Cms\Controller
 */
abstract class AbstractEngineController implements
    EngineAwareInterface,
    EngineDecoratorAwareInterface
{

    use EngineDecoratorAwareTrait;
    use EngineAwareTrait;
    use MetaEngineTrait;
    use AssetEngineTrait;


    /**
     * @param \Cms\Client\Article\Model\CategoryRestfulModel $category
     * @return \Cms\Controller\AbstractEngineController
     */
    protected function decorateWithArticleCategory(CategoryRestfulModel $category)
    {
        // ajoute les plugin a l'engine
        foreach ($category->plugins ?: [] as $pluginModel) {
            $this->getEngineDecorator()->decorate($this->engine, $pluginModel);
        }
        return $this;
    }
}
