<?php


namespace Cms\Extension\TemplateBloc;

/**
 * Class BlocHandlerResponse
 * @package Cms\Extension\TemplateBloc
 */
class BlocHandlerResponse
{
    /** @var mixed */
    private $contentData;

    /** @var string|null */
    private $templatePath;

    /**
     * BlocHandlerResponse constructor.
     * @param mixed $contentData
     * @param string|null $templatePath
     */
    public function __construct($contentData, $templatePath = null)
    {
        $this->contentData = $contentData;
        $this->templatePath = $templatePath;
    }

    /**
     * @return mixed
     */
    public function getContentData()
    {
        return $this->contentData;
    }

    /**
     * @return string|null
     */
    public function getTemplatePath()
    {
        return $this->templatePath;
    }
}
