<?php


namespace Cms\LinkResource\Provider\CMS;

use Cms\Client\Service\GeodataService;
use Cms\LinkResource\LinkResourceType;
use Cms\LinkResource\Provider\ProviderClientAdapterInterface;
use Cms\LinkResource\Provider\ProviderRestfulClientAdapter;
use Cms\LinkResource\Provider\SearchAdapterAwareInterface;
use Cms\LinkResource\Provider\SearchAdapterAwareTrait;

/**
 * Class CmsGeodataProvider
 * @package Cms\LinkResource\Provider\CMS
 */
class CmsGeodataProvider extends AbstractCmsGeodataProvider implements
    SearchAdapterAwareInterface
{

    use SearchAdapterAwareTrait;

    /** @var \Cms\Client\Service\GeodataService */
    private $geodataService;

    /**
     * CmsGeodataProvider constructor.
     * @param \Cms\Client\Service\GeodataService $geodataService
     */
    public function __construct(GeodataService $geodataService)
    {
        $this->geodataService = $geodataService;
    }


    /**
     * @param LinkResourceType|string $typeCode
     * @return \Cms\Client\Geodata\AdminClient|\Cms\Client\Geodata\CityClient|\Cms\Client\Geodata\CountryClient|null
     */
    protected function getClientByTypeCode($typeCode)
    {
        switch ((string)$typeCode) {
            case LinkResourceType::GEO_ADMIN:
                return $this->geodataService->getAdminClient();
                break;
            case LinkResourceType::GEO_CITY:
                return $this->geodataService->getCityClient();
                break;
            case LinkResourceType::GEO_COUNTRY:
                return $this->geodataService->getCountryClient();
                break;
        }
        return null;
    }

    /**
     * @param mixed $typeCode
     * @return \Cms\LinkResource\Provider\ProviderClientAdapterInterface
     * @throws \RuntimeException
     */
    protected function getClientAdapter($typeCode) : ProviderClientAdapterInterface
    {
        $client = $this->getClientByTypeCode($typeCode);
        if ($client !== null) {
            return new ProviderRestfulClientAdapter($client);
        }
        throw new \RuntimeException('no client adapter');
    }

    /**
     * @param LinkResourceType|string $typeCode
     * @param mixed $query
     * @return string[]
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function execSearch($typeCode, $query)
    {
        $country = $level = null;
        if (\is_array($query)) {
            $level = !empty($query['level']) ? (int)$query['level'] : $level;
            $country = $query['country'] ?? null;
            $query = $query['text'] ?? '';
        }
        if (empty($query)) {
            return [];
        }
        $resourceIds = [];
        if (($resource = $this->getData($typeCode, $query))) {
            $resourceIds = [$resource->id];
        }
        switch ((string)$typeCode) {
            case LinkResourceType::GEO_CITY:
                $results = $this->getClientByTypeCode($typeCode)
                    ->autocomplete((string)$query, $country);
                // On récupère les id de chaque modele pour les renvoyer
                foreach ($results as $model) {
                    $resourceIds[] = $model->id;
                }
                return $resourceIds;
                break;
            case LinkResourceType::GEO_ADMIN:
                $results = $this->getClientByTypeCode($typeCode)
                    ->getIndexBySearch($query, $country, $level);
                // On récupère les id de chaque modele pour les renvoyer
                foreach ($results as $model) {
                    $resourceIds[] = $model->id;
                }
                return $resourceIds;
                break;
            case LinkResourceType::GEO_COUNTRY:
                $results = $this->getClientByTypeCode($typeCode)
                    ->getIndexBySearch($query);
                // On récupère les id de chaque modele pour les renvoyer
                foreach ($results as $model) {
                    $resourceIds[] = $model->id;
                }
                return $resourceIds;
                break;
        }
        return $resourceIds;
    }
}
