<?php


namespace Cms\Model\Article;

use Cms\Model\I18nModelInterface;
use Cms\Model\I18nModelTrait;
use Cms\Model\SeoAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class ArticleI18nModel
 * @package Cms\Model\Article
 * @property int $article_id
 * @property string $title
 * @property string $slug
 * @property string $cover_title
 * @property string $short_title
 * @property ArticleContent $abstract
 * @property ArticleContent $cover_abstract
 * @property string $short_abstract
 * @property ArticleContent $content
 */
class ArticleI18nModel extends DomainObjectAbstract implements I18nModelInterface
{

    use I18nModelTrait;
    use SeoAwareModelTrait;

    /**
     * @relation
     * @var int
     */
    protected $article_id;

    /** @var  string */
    protected $title;

    /** @var  string */
    protected $slug;

    /** @var  string */
    protected $cover_title;

    /** @var  string */
    protected $short_title;

    /** @var  ArticleContent */
    protected $abstract;

    /** @var  ArticleContent */
    protected $cover_abstract;

    /** @var  string */
    protected $short_abstract;

    /** @var  ArticleContent */
    protected $content;
}
