<?php


namespace Cms\Model\Article\Category;

use Cms\Model\I18nModelInterface;
use Cms\Model\I18nModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class CategoryI18nModel
 * @package Cms\Model\Article\Category
 * @property int $category_id
 * @property string $name
 * @property string $slug
 * @property string $abstract
 */
class CategoryI18nModel extends DomainObjectAbstract implements I18nModelInterface
{

    use I18nModelTrait;

    /**
     * @relation
     * @var int
     */
    protected $category_id;

    /** @var  string */
    protected $name;

    /** @var  string */
    protected $slug;

    /** @var  string */
    protected $abstract;
}
