<?php


namespace Cms\Model\Asset\Config;

use Cms\Model\AbstractConfigModel;
use Cms\Model\Asset\AssetModel;
use Cms\Model\Asset\AssetProfil;

/**
 * Class ConfigFactory
 * @package Cms\Model\Asset\Config
 */
class ConfigFactory
{
    /**
     * @param AssetModel $assetModel
     * @param array $dataset
     * @return ConfigModel
     * @throws \InvalidArgumentException
     */
    public static function createConfigFromAsset(
        AssetModel $assetModel,
        array $dataset = []
    ) : ConfigModel {
        // check de la config
        $configModel = (new ConfigModel())->populate($dataset, true);
        if ($assetModel->id) {
            $configModel->asset_id = $assetModel->id;
        }
        $configModel->title = $dataset['title'] ?? null;
        if (empty($dataset['config'])) {
            $dataset['config'] = $dataset;
        }
        $configModel->config = self::createFromAssetProfil($assetModel->profil, $dataset['config']);
        return $configModel;
    }

    /**
     * @param AssetProfil|string $assetProfil
     * @param array $dataset
     * @return AbstractConfigModel|null
     * @throws \InvalidArgumentException
     */
    public static function createFromAssetProfil($assetProfil, array $dataset = [])
    {
        if (!$assetProfil instanceof AssetProfil
            && !AssetProfil::isValid($assetProfil)
        ) {
            throw new \InvalidArgumentException('profil unknown');
        }
        switch ((string)$assetProfil) {
            case AssetProfil::EMBED_VIDEO:
                return (new ConfigEmbedVideoModel())->populate($dataset, true);
                break;
            case AssetProfil::IMAGE:
                return (new ConfigImageModel())->populate($dataset, true);
                break;
            default:
                return null;
                break;
        }
    }
}
