<?php

namespace Cms\Model\CmsUser;

/**
 * Class CmsUserUtils
 * @package Cms\Model\CmsUser
 */
class CmsUserUtils
{

    /** salt pour le hash de la clé */
    const SALT_PASSWD_KEY = '@PASSWORD_KEY';

    /** separator pour le clé */
    const SEPARATOR_PASSWD_KEY = '---';

    /**
     * @param string $passwordKey
     * @return int|null
     */
    public static function getUserIdWithPasswordKey(string $passwordKey)
    {
        $passwordKey = base64_decode($passwordKey);
        $passwordPart = explode(self::SEPARATOR_PASSWD_KEY, $passwordKey);
        if (count($passwordPart) === 3
            && password_verify($passwordPart[0] . self::SALT_PASSWD_KEY, $passwordPart[1])
        ) {
            return $passwordPart[0];
        }
        return null;
    }

    /**
     * @param int $userId
     * @return string
     */
    public static function generatePasswordKey(int $userId) : string
    {
        // crypt id for checking
        $hash = password_hash($userId . self::SALT_PASSWD_KEY, PASSWORD_BCRYPT);
        return base64_encode(
            implode(self::SEPARATOR_PASSWD_KEY, [
                $userId,
                $hash,
                uniqid('pw', true),
            ])
        );
    }
}
