<?php

namespace Cms\Route;

/**
 * Class AbstractPathBuilderDecorator
 * @package Cms\Route
 */
abstract class AbstractPathBuilderDecorator
{

    /**
     * @param string $identifier
     * @param \Cms\Route\PathBuilder $builder
     * @return string|\Cms\Route\PathBuilder
     */
    final public function __invoke(string $identifier, PathBuilder $builder)
    {
        return $this->decorate($identifier, $builder);
    }

    /**
     * @param string $identifier
     * @param \Cms\Route\PathBuilder $builder
     * @return string|\Cms\Route\PathBuilder
     */
    abstract protected function decorate(string $identifier, PathBuilder $builder);
}
