<?php


namespace Cms\Search\Geodata;

use Cms\Model\Geodata\AdminModel;
use Cms\Search\Mapping\GeoAdminDocumentTrait;
use Cms\Search\Mapping\GeoAdminPropertiesTrait;
use Elastica\Document;
use Move\Search\ElasticMappingBuilder;

/**
 * Class CityIndexFactory
 * @package Cms\Search\Geodata
 */
class AdminIndexFactory
{

    use GeoAdminDocumentTrait;
    use GeoAdminPropertiesTrait;

    /** Nom du type pour les regions dans l'index */
    const MAPPING_NAME = 'admin';

    /**
     * @return \Move\Search\ElasticMappingBuilder
     */
    public static function createMappingBuilder() : ElasticMappingBuilder
    {
        $self = new self();
        $builder = new ElasticMappingBuilder(self::MAPPING_NAME, $self->getGeoAdminProperties());
        return $builder;
    }

    /**
     * @param \Cms\Model\Geodata\AdminModel $adminModel
     * @param array $i18n
     * @return \Elastica\Document
     * @throws \InvalidArgumentException
     */
    public static function createDocument(AdminModel $adminModel, array $i18n = []) : Document
    {
        if (!$adminModel instanceof AdminModel) {
            throw new \InvalidArgumentException('can only create document from AdminModel');
        }

        // data du document
        $adminArray = $adminModel->getArrayCopy();
        $adminArray['i18n'] = $i18n;
        $adminData = self::buildGeoAdminMapping($adminArray);

        // envoi des données
        $document = new Document($adminModel->id, $adminData, self::MAPPING_NAME);
        return $document;
    }
}
