<?php

namespace Cms\Search\Mapping;

use Move\Search\Analyzer\GeoFrenchAnalyzer;
use Move\Search\Analyzer\GeoFrenchSearchAnalyzer;
use Move\Search\Analyzer\SearchWordAnalyzer;
use Move\Search\Analyzer\WordAnalyzer;
use Move\Search\Mapping\ElasticMappingProperty;
use Move\Search\Mapping\KeywordMapping;
use Move\Search\Mapping\TextMapping;

/**
 * Trait AddressPropertiesTrait
 * @package Cms\Search\Mapping
 */
trait AddressPropertiesTrait
{

    /**
     * @return array
     */
    private function getAddressProperties() : array
    {
        $properties = [
            (new ElasticMappingProperty('id', 'long', false)),

            new ElasticMappingProperty('geo_location', 'geo_point', false),

            (new TextMapping('city_name'))
                ->withAnalyzer(new WordAnalyzer(), new SearchWordAnalyzer())
                ->withOption('fields', [
                    'raw' => [
                        'type' => 'keyword',
                        'index' => false,
                    ],
                ]),
            (new TextMapping('city_name_fre', false))
                ->withAnalyzer(new GeoFrenchAnalyzer(), new GeoFrenchSearchAnalyzer()),
            (new KeywordMapping('city_osm_id', false)),
            (new ElasticMappingProperty('city_geodata_id', 'long', false)),

            (new KeywordMapping('address1', false)),
            (new KeywordMapping('address2', false)),

            (new KeywordMapping('postal_code', false)),

            (new KeywordMapping('admin1_code', false)),
            (new KeywordMapping('admin2_code', false)),

            (new KeywordMapping('country_code')),

            (new KeywordMapping('type')),
        ];
        return $properties;
    }
}
