<?php

namespace Cms\Specification;

use Cron\CronExpression;
use Move\Specification\Specification;

/**
 * Class PeriodicitySpecification
 * @package Cms\Specification
 */
class PeriodicitySpecification extends Specification
{

    /**
     * @param mixed $object
     * @return bool
     */
    public function isSatisfiedBy($object) : bool
    {
        if (\is_string($object) && CronExpression::isValidExpression($object)) {
            return true;
        }
        return false;
    }
}
